% Luca Guglielmetti, Lausanne, january 2011
% plot hazard-zonation for rockfalls
% rockfall modelisation made by Rocscience's RocFall
clear all, close all, clc;

data_p = load('profiles/t2_profile.txt','ascii');
data_b = load('profiles/t2_end.txt','ascii');
data_h = load('profiles/t2_bounces.txt','ascii');
data_e = load('profiles/t2_energy.txt','ascii');
data_m = load('profiles/t2_materials.txt','ascii');

% Dngerosit (probabilit de ropture)
% 3 = elevee ; 2 = moyenne ; 1 = faible
P_ROPTURE = 3;

% matrice de danger (intensit, attainte)
MD = [2, 1, 1; 3, 2, 1; 3, 3, 3; ];

% matrice d'attainte (prob attainte, prob ropture)
MA = [0, 0, 1; 0, 1, 2; 1, 2, 3];

% matrice legende
COLORS = ['w', 'y', 'b', 'r']; 

%% profile  
x = data_p(:,1);
y = data_p(:,2);

figure(1);
subplot(4,1,1);
plot(x,y);
ylabel('z [m]');
axis tight;
draw_lines(data_m);

%% end points

x = data_b(:,1);
y = data_b(:,2);
y = y./sum(y)*100;

subplot(4,1,2);

cdf = zeros( length(y),1);
for i = 2:length(y)
    cdf(i) = cdf(i-1) + y(i);
end

cdf = cdf./max(cdf);

plot(x,cdf);
draw_lines(data_m);
ylabel('CDF [1]');
axis tight;

%% bounce height
x = data_h(:,1);
y = data_h(:,2);

subplot(4,1,3);
plot(x,round(y));
ylabel('Bounce height [m]');
draw_lines(data_m);
axis tight;

%% kinetic energy
x = data_e(:,1);
energie = data_e(:,2);

subplot(4,1,4);
plot(x,round(energie)./1000,'-');
ylabel('Total kinetic energy [kJ]');
xlabel('x [m]');
draw_lines(data_m);
axis tight;

%% intensite
figure(2);
 
x = data_b(:,1);
atteinte = zeros(1,length(cdf));
pdf = 1-cdf;

for i = 1:length(pdf)
    if pdf(i) < 10^-4/100
        atteinte(i) = 0
    elseif pdf(i) < 0.01/100
        atteinte(i) = 1
    elseif pdf(i) < 1/100     
        atteinte(i) = 2
    else
        atteinte(i) = 3    
    end
end

subplot(3,1,1);
plot(x,atteinte);
ylabel('Atteinte');
axis tight;

atteinte_ponderee = zeros(1,length(atteinte));
for i = 1:length(atteinte)
    if (atteinte(i) > 0)
        atteinte_ponderee(i) = MA(atteinte(i), P_ROPTURE);
    else
        atteinte_ponderee(i) = 0;
    end
end

% attainte
x = data_e(:,1);
intensite = zeros(1,length(x));
for i = 1:length(intensite)
    if energie(i) < 30
        intensite(i) = 1
    elseif energie(i) < 300
        intensite(i) = 2
    else
        intensite(i) = 3
   end
end

subplot(3,1,2);
plot(x,intensite);
ylabel('Intensite');

axis tight;

%% DANGER

l = min(length(intensite),length(atteinte_ponderee));
danger = zeros(1,l);

for i = 1:l
    if(atteinte_ponderee(i) > 0)
        danger(i) = MD(intensite(i),atteinte_ponderee(i));
    else
        danger(i) = 0;
    end
end
subplot(3,1,3);
%plot(x(1:l),danger);

hold on;
for i = 2:l
    y1 = 0;
    y2 = 1;
    x1 = x(i-1);
    x2 = x(i);
    c = COLORS(danger(i)+1)
    fill([x1,x2,x2,x1],[y1,y1,y2,y2], c);
end

axis([min(x), max(x), -1, 2]);

