% LG, juin 2013
% calcule projection d'une grotte sur une coupe verticale

function [M_profile] = get_profile_grotte(azimuth, M_in, M_grotte)

    % coordinate system of the profile plane
    e1 = [cos(azimuth-pi/2), sin(azimuth-pi/2), 0];
    e2 = [0, 0, 1];
    
    % profile matrix
    M_profile = zeros(size(M_grotte,1),2);
    
    for i=1:length(M_grotte)
        % displacement vector from P_in [y,y,z]
        v = [M_grotte(i,:)]
        
        % projection over profile plane [e1,e2]
        v1 = dot(v,e1)
        v2 = dot(v,e2)
        
        % convert into profile's coordinate system [dx,z]
        M_profile(i,1) = M_in(1) - v1;
        M_profile(i,2) = M_in(2) + v2;        
    end
    
end
