% LG, juin 2013
% dessine surface topographique et projection d'une grotte sur une coupe verticale

clear all, close all, clc;

%M_in = [565616,147945]; %entree [x,y]
M_in = [650,1740]; % entree [e1,e2]
azimuth_deg = 293; % azimuth cozupe [degrees]

file_topo = '.\data\profile_topo.txt';
file_grotte = '.\data\topo_grotte.txt';

M_topo = load(file_topo);
M_grotte = load(file_grotte);

azimuth = radians(azimuth_deg);

% projection de la grotte sur le profil
M_profile = get_profile_grotte(azimuth, M_in, M_grotte);

% dessin
img = figure(1);
hold on;
plot(M_topo(:,1),M_topo(:,2),'k');
plot(M_profile(:,1),M_profile(:,2),'bx');
axis equal;

