% draw spectrum of discrete fourier transform

function d_draw_dft ()
  global x FN;

  N = length(x);
  X = fft(x,N);
  Nf = N/2 + 1;
  f = linspace(0,FN,Nf);
  
  hold on;
  plot(f,abs(X(1:Nf)));
  axis([0,0.015,0,100000]);
  box on;
  xlabel('Frequency [d^{-1}]'); ylabel('Amplitude');
  title('DFT spectrum of the whole signal');
  hold off;
end