% plot flood frequency analysis

function d_draw_ffa()
global DPY;

% get annual peaks
X = sort(d_get_peaks());
n = length(X);

%%%%%%%%%%%%%%%%%
% empirical data

% calculate empirical daily probability from extreme events
[q,cd] = d_get_cd();

for i=1:n   
   % get daily flow probability for extreme events
   cpde(i) = cd( floor(X(i) + 1) );
   % calculate yearly exceedance probability from
   pye(i) = 1 - binopdf( 0,DPY, (1-cpde(i)) );
end

% calculate return period of empirical yearly exceedance
Tye = 1./pye;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Gumbel distribution (extreme event distribution type I)

iX = linspace(0,max(X), max(X));
alpha_ = sqrt(var(X)*6/(pi^2));
epsilon_ = mean(X) - 0.5772 * alpha_;
% single event gumbel distribution
cyg =  exp( -exp(-(iX-epsilon_)/alpha_) );
% return period (with exceedence probability)
Tyg = 1./(1 - cyg);

semilogy(iX,Tyg,'r',X,Tye,'xb');
xlabel('Q [m^3.s^{-1}]'); ylabel('T [a]');
legend('Gumble distribution','empirical');
title('flood frequency analysis');
