% draw probability distributions

function d_draw_pdf ()
  global DPY;
  
  [q,p] = d_get_pd();  
  [cq,cp] = d_get_cd();
  py = 1 - cp.^DPY;
  
  hold on;  
  
  plot(q,p,'bx');
  plot(cq,cp,'gx');  
  plot(q,py,'rx');    
    
  xlabel('Q [m^3.s^{-1}]'); ylabel('f');
  title('empirical probability distribution functions');
  legend('PDF: p(Q < X < Q+1) [d^{-1}]','CDF: p(X < Q) [d^{-1}]','P-flood: p(X \geq Q) [year^{-1}]');
  box on;
  
  hold off;
end