% plot plotting position of extreme events

function d_draw_pp()

% get annual peaks
X = sort(d_get_peaks());

n = length(X);
i = linspace(n,1,n)';

% Weibull plotting position
q = i./(n+1);
Y = -log( -log(1-q));

% fit with stright line
ppf = fit(Y,X,'poly1');
Yi = linspace(min(Y),max(Y),100)';
Xi = ppf(Yi);

% plot
plot (Y, X, 'x', Yi, Xi, 'r');
title('Weibull plotting position fits Gumbel distribution');
xlabel('reduced Gumble variable Y [1]'); ylabel('Q [m^3.s^{-1}]')
end
