% return annual peaks (maximal flood of each year)

function fe = d_get_peaks()

global x DPY;
nyears = floor(length(x)/DPY)-1;
fe=zeros(nyears,1);
k=1;

for i=0:nyears
    % get flow within this year
    temp_x = x(i*DPY+1:(i+1)*DPY);
    % get the peaks of this year
    pks = sort( findpeaks(temp_x,'minpeakheight',10,'minpeakdistance',5) ,'descend');
    % get maximun peak if available
    if(numel(pks)>0)
        fe(k)=pks(1);
        k=k+1;
    end
end

end