% Luca Guglielmetti, Zürich 2009
% v. 0.6
% statistics of a river stream

% load data
d_data = load('day_stream.txt');

% constants and data
global DPY MIN_EE FS FN
DPY = 365;                            % days pro year
MIN_EE =5;                            % minimum flow for an extreme event
FS = 1;                               % sampling frequency [1/d]
FN = FS/2;                            % nyquist frequency [1/d]

global t x n xs;
t = d_data(:,1);                      % time [d]
x = d_balance_holes( d_data(:,2) );   % streamflow [m^3 / s]
n = max(size(x));                     % # data
xs = sort(x);

figure(1);
clf;

subplot(1,2,1);
d_draw_signal;

subplot(1,2,2);
d_draw_dft;

figure(2);
clf;
hold on;
d_draw_pdf;
hold off;

figure(3);
clf;
subplot(1,2,1);
d_draw_pp;

subplot(1,2,2);
d_draw_ffa;
