% Luca Guglielmetti, Lausanne 2012
% calculate true displacement of a fault
% based on the apparent displacement of a planar structure
% and its orientation

clear all, close all, clc;

%% MAP DATA AND OTHER CONSTANTS

% cylindrical coordinates:
% positive dip = up emisphere
% negative dip = down emisphere

% certesian coordinates:
% x = est cosine
% y = north cosine
% z = up cosinebetweent

% pitch angle between:
% intersection of bedding plane and fault plane (calculate)
% AND
% gradient of bedding plane
% (graphically measured with a stereonet)
alpha = 52;

% pitch angle of mouvement
beta = 20;

% dip of fault plane
f_dip = 57;
gamma = 90-f_dip;

p1x = 585715;
p1y = 118345;
p1z = 655;

p2x = 586070;
p2y = 118395;
p2z = 510;

% vector of intersection between bedding plane and fault plane (calculate
% graphically with stereonet)
v1 = [86;-30];

% direction of movement
v2 = [74+180;17];

%% start
alpha = radians(alpha);
beta = radians(beta);   
gamma = radians(gamma);

p1 = [p1x;p1y;p1z];
p2 = [p2x;p2y;p2z];

% l_tot_old e' sbagliato!!
l_max = norm(p2-p1);
v_tot = p2-p1;
h_tot = abs(v_tot(3))/cos(gamma);
l_tot = sqrt(l_max^2 - h_tot^2);

%% calculate
m1 = -1/tan(alpha);
q1 = h_tot;
m2 = -tan(beta);
q2 = tan(beta)*l_tot;

p3x = (q2-q1)/(m1-m2);
p3y = m1*p3x + q1;

d_f = sqrt((l_tot-p3x)^2 + p3y^2)
d_bp = sqrt(p3x^2 + (h_tot-p3y)^2)

m3 = -tan(pi/2-gamma);
q3 = abs(v_tot(3));

%% plot
figure(1);
hold on;

x = 1:l_tot;
y1 = m1*x+q1;
y2 = m2*x+q2;
plot(x,y1,'b');
plot(x,y2,'r');

plot(0,h_tot,'o','MarkerEdgeColor','b','MarkerFaceColor','b');
plot(l_tot,0,'o','MarkerEdgeColor','r','MarkerFaceColor','r');
plot(p3x,p3y,'o','MarkerEdgeColor','k','MarkerFaceColor','k');

axis equal;
xlabel('h[m]');
ylabel('h[m]');

figure(2);
y = 1:q3;
x = (y-q3)/m3;
plot(x,y,'k');
axis equal;

%% verify

[v1y,v1x,v1z] = SphToCart(radians(v1(1)),radians(v1(2)),0);
[v2y,v2x,v2z] = SphToCart(radians(v2(1)),radians(v2(2)),0);
v1c = [v1x;v1y;v1z];
v2c = [v2x;v2y;v2z];
v1c = v1c/norm(v1c);
v2c = v2c/norm(v2c);

p3_a = p1 + v1c*d_bp;
p3_b = p2 + v2c*d_f;
p3_a = round(p3_a)
p3_b = round(p3_b)

Dp3 = p3_a - p3_b;
Delta = round(norm(Dp3))
p3 = round(p3_b + Dp3/2)
